/**
* \file: VrCaptureAudioChannel.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for voice recognition capture
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <string>
#include <adit_logging.h>
#include <bdcl/AilAudioSource.h>

#include "VrCaptureAudioChannel.h"

LOG_IMPORT_CONTEXT(tbdcl)

// todo check return values of the calles methods

namespace adit { namespace bdcl {

// todo replace raw ptr with smart ptr
VrCaptureAudioChannel::VrCaptureAudioChannel(CoreCallbackDealer* inCallbackDealer)
{
    mAudioSource = new AilAudioSource(this, inCallbackDealer);

    /* set config items */
    mAudioSource->setConfigItem("audio-capture-device", "device=microphone periodms=8 inittoutms=2000");
    mAudioSource->setConfigItem("disable-real-time-priority-audio", "0");
    mAudioSource->setConfigItem("audio-threads-real-time-priority", "61");
    mAudioSource->setConfigItem("audio-source-channels", "1");
    mAudioSource->setConfigItem("audio-source-bits-per-sample", "16");
    mAudioSource->setConfigItem("audio-source-sampling-rate", "16000");

    mAudioSource->initialize();
}

VrCaptureAudioChannel::~VrCaptureAudioChannel()
{
    mAudioSource->teardown();

    delete mAudioSource;
    mAudioSource = nullptr;
}

void VrCaptureAudioChannel::teardown()
{
    if (mAudioSource != nullptr)
    {
        LOG_INFO((tbdcl, "%s()  Teardown AudioSource endpoint", __FUNCTION__));
        mAudioSource->teardown();
    }
}

void VrCaptureAudioChannel::onMicRecordWakeupStart()
{
    LOGD_DEBUG((tbdcl, "%s invoked", __PRETTY_FUNCTION__));
    mAudioSource->captureStart();
}

void VrCaptureAudioChannel::onMicRecordEnd()
{
    LOGD_DEBUG((tbdcl, "%s invoked", __PRETTY_FUNCTION__));
    mAudioSource->captureStop();
}

void VrCaptureAudioChannel::onMicRecordRecognitionStart()
{
    LOGD_DEBUG((tbdcl, "%s invoked", __PRETTY_FUNCTION__));
    mAudioSource->captureStart();
}

void VrCaptureAudioChannel::onError(bdclErrorCodes inErrorCode)
{
    LOG_ERROR((tbdcl, "Error: %d on VR Capture audio channel", static_cast<uint32_t>(inErrorCode)));
}

} } /* namespace adit { namespace bdcl */
